 ; Ŀ
 ;   Lwpl - convert polylines in a block to lwpolylines.                   
 ;   Copyright 2002, 2009 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Ssho - print the contents of an ss.                                   
 ;   Takes one argument: ss, a selection set.                              
 ;   Calls nothing, returns nothing, prints enity data listings.           
 ;   Not currently called, but nice to have.                               
 ; 
 (DEFUN SSHO (ss / num sub)
  (setq num 0)
  (while (setq sub (ssname ss num))
         (setq num (1+ num))
         (print sub)
         (print (entget sub)))
 (princ))
 ; Ŀ
 ;   Ssho end.                                                             
 ; 

 ; Ŀ
 ;   Fepo - find all blocks with a polyline as a subentity.                
 ;   Takes no arguments.                                                   
 ;   Calls nothing, returns a list of block names.                         
 ; 
 (DEFUN FEPO (/ rewind blok blnam enam plist)
 ; Ŀ
 ;   Step through the block table, look for the block as a subentity.      
 ; 
  (setq rewind t)                                   ; set the rewind flag
  (while (setq blok (tblnext "block" rewind))       ; next block in table
         (setq rewind ())                           ; clear the rewind flag
 ; Ŀ
 ;   Save the block name.                                                  
 ; 
         (setq blnam (cdr (assoc 2 blok)))
 ; Ŀ
 ;   Get the name of the first subentity.                                  
 ; 
         (setq enam (cdr (assoc -2 blok)))          ; entity name
         (while (and enam (/= (car plist) blnam))
                (if (= "POLYLINE" (cdr (assoc 0 (entget enam))))
                    (setq plist (cons blnam plist))
                    (setq enam (entnext enam)))))
 plist)
 ; Ŀ
 ;   Fepo end.                                                             
 ; 

 ; Ŀ
 ;   Morloc - explode an entity, return an ss of the new subentities.      
 ;   Takes one argument, an entity name.                                   
 ; 
 (DEFUN MORLOC (enam / aaa ss)
 ; Ŀ
 ;   Find the last entity in the drawing.                                  
 ; 
  (setq aaa (entlast))
  (while (entnext aaa)
         (setq aaa (entnext aaa)))
 ; Ŀ
 ;   Explode the entity.                                                   
 ; 
  (command ".explode" enam)
 ; Ŀ
 ;   Find the debris left by the explosion.                                
 ; 
  (setq ss (ssadd))
  (while (setq aaa (entnext aaa))
         (ssadd aaa ss))
 ss)
 ; Ŀ
 ;   Morloc end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Nopa - remanufacture a block, convert polylines to lw.     
 ;   Arguments: Blnam, a block name.                                       
 ; 
 (DEFUN NOPA (blnam / *error* ss num sub enam ssgnu)
  (setq attreq (getvar "attreq"))
  (defun *error* (shk)
   (setvar "attreq" attreq)
  (princ))
  (setvar "attreq" 0)
  (command ".insert" blnam "0,0,0" 1 "" "0")
  (setvar "attreq" 0)
  (setq ss (morloc (entlast)))
  (setq num 0)
  (while (setq sub (ssname ss num))
         (if (= "POLYLINE" (cdr (assoc 0 (entget sub))))
 ; Ŀ
 ;   The ename of a polyline is unchanged after Convertpoly is used on it. 
 ; 
             (command "convertpoly" "l" sub ""))
         (setq num (1+ num)))
 ; Ŀ
 ;   Morloc returns subentities as part of the ss, and once convertpoly    
 ;   has changed polylines to lwpolylines the enames of the vertices       
 ;   won't have corresponding entities.  This will crash AutoCAD.          
 ;   So clean out the ss.                                                  
 ; 
  (setq num 0)
 ; Ŀ
 ;   Hmmm.  Autocad won't crash if you ssdel an ename which Convertpoly    
 ;   has eaten, but it won't be happy either.                              
 ; 
  (setq ssgnu (ssadd))
  (while (setq sub (ssname ss num))
         (setq num (1+ num))
         (if (entget sub)
             (ssadd sub ssgnu)))
  (command ".block" blnam "y" "0,0,0" ssgnu "")
 (princ))
 ; Ŀ
 ;   Subroutine Nopa end.                                                  
 ; 

 ; Ŀ
 ;   Lwpl.                                                                 
 ; 
 (DEFUN C:LWPL (/ blist num blnam)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setvar "attdia" 0)
  (setq blist (fepo))
  (if blist
     (progn
          (setq num 0)
          (while (setq blnam (nth num blist))
                 (setq num (1+ num))
                 (write-line (strcat (strcase (substr blnam 1 1))
                                     (strcase (substr blnam 2) t)))
                 (nopa blnam)))
     (write-line "\nNo Blocks in This Drawing Contain Heavy Polylines."))
  (command ".undo" "end")
 (princ))